// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  fmtparser.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "fmtparser.h"
#include <string.h>


// ----------------------------------------------------------------------------
//  NX
// ----------------------------------------------------------------------------

class CharClass
{
public:
  CharClass(void);
  virtual ~CharClass() {}

  int GetCharClass(unsigned char inC) const { return mCharClass[inC]; }

protected:
  void SetCharClass(unsigned char inChr, int inCls);
  void SetCharsClass(unsigned char inChrBegin, unsigned char inChrEnd, int inCls);

private:
  int mCharClass[256];
};


// ---
//  RXgN^
// ---

CharClass::CharClass(void)
{
  memset(mCharClass, 0, sizeof(int) * 256);
}


// ---
//  ̃NXݒ肷
// ---

void CharClass::SetCharClass(unsigned char inChr, int inCls)
{
  mCharClass[inChr] = inCls;
}


// ---
//  w͈͂̃̕NXݒ肷
// ---

void CharClass::SetCharsClass(unsigned char inChrBegin, unsigned char inChrEnd, int inCls)
{
  for (int theI = inChrBegin; theI < inChrEnd; theI++)
    mCharClass[theI] = inCls;
}


// ----------------------------------------------------------------------------
//  FormatParser pNX
// ----------------------------------------------------------------------------

class FormatCharClass : public CharClass
{
public:
  enum
  {
    DIGIT = 1,
    PERCENT,
    YEAR,
    MONTH,
    DAY,
    HOUR,
    MINUTE,
    SECOND,
    NUMBER
  };

  FormatCharClass(void)
  {
    SetCharsClass('0', '9', DIGIT);
    SetCharClass('%', PERCENT);
    SetCharClass('y', YEAR);
    SetCharClass('m', MONTH);
    SetCharClass('d', DAY);
    SetCharClass('H', HOUR);
    SetCharClass('M', MINUTE);
    SetCharClass('S', SECOND);
    SetCharClass('n', NUMBER);
  }
  ~FormatCharClass() {}
};


// ----------------------------------------------------------------------------
//  ̉
// ----------------------------------------------------------------------------

// ---
//  RXgN^EfXgN^
// ---

FormatParser::FormatParser(void)
{
  int theI;
  for (theI = 0; theI < MAX_TOKENS; theI++)
    mTokens[theI] = NULL;
  mTokenCount = 0;
  mChrCls = new FormatCharClass;
}

FormatParser::~FormatParser(void)
{
  FreeMem();
  delete mChrCls;
}


// ---
//  gpĂ郁
// ---

void FormatParser::FreeMem(void)
{
  for (int theI = 0; theI < mTokenCount; theI++)
  {
    delete mTokens[theI];
    mTokens[theI] = NULL;
  }
  mTokenCount = 0;
}


// ---
//  ̃NX擾
// ---

int FormatParser::GetCharClass(int inC) const
{
  return mChrCls->GetCharClass(inC);
}


// ---
//  ͂
// ---

int FormatParser::Parse(const char *inFmt)
{
  FreeMem();

  const char  *theStrBegin = NULL;
  const char  *theP = inFmt;
  while ('\0' != *theP)
  {
    switch (GetCharClass(*theP))
    {
    case FormatCharClass::PERCENT:
      // '%' QĂ̂ȂP '%' Ɖ߂
      if (FormatCharClass::PERCENT == GetCharClass(*(theP + 1)))
      {
        // |C^CNgāA default ł̏ɔC
        theP++;
      }
      else  // P '%' Ȃ珑tB[h
      {
        if (NULL != theStrBegin)
        {
          if (0 != CopyString(theStrBegin, theP))
            return 1;
          theStrBegin = NULL;
        }
        // theP  ParseFormField ōXV܂
        if (0 != ParseFormField(theP))
          return 1;
        break;
      }
      // X[

    default:  // '%' ȊO
      if (NULL == theStrBegin)
        theStrBegin = theP;
      theP++;
    }
  }

  // ŌオŏIĂH
  if (NULL != theStrBegin)
  {
    if (0 != CopyString(theStrBegin, theP))
      return 1;
  }

  return 0;
}


// ---
//  tB[h͂
// ---

int FormatParser::ParseFormField(const char* &ioStr)
{
  if (MAX_TOKENS <= mTokenCount)
    return 1;

  TokenValue  *theVal = new TokenValue;
  mTokens[mTokenCount++] = theVal;

  ioStr++;

  // ݒ肳Ă邩H
  if (FormatCharClass::DIGIT == GetCharClass(*ioStr))
  {
    if ('0' == *ioStr)
    {
      theVal->SetWidth(0);  // ͉
      // ̂Ƃɐ悤ȂG[ƂȂ
    }
    else
    {
      int  theDigits = 0;
      do {
        theDigits = theDigits * 10 + (*ioStr++ - '0');
      } while (FormatCharClass::DIGIT == GetCharClass(*ioStr));
      theVal->SetWidth(theDigits);
    }
  }

  switch (GetCharClass(*ioStr++))
  {
  case FormatCharClass::YEAR: theVal->SetValueType(TokenValue::YEAR); break;
  case FormatCharClass::MONTH: theVal->SetValueType(TokenValue::MONTH); break;
  case FormatCharClass::DAY: theVal->SetValueType(TokenValue::DAY); break;
  case FormatCharClass::HOUR: theVal->SetValueType(TokenValue::HOUR); break;
  case FormatCharClass::MINUTE: theVal->SetValueType(TokenValue::MINUTE); break;
  case FormatCharClass::SECOND: theVal->SetValueType(TokenValue::SECOND); break;
  case FormatCharClass::NUMBER: theVal->SetValueType(TokenValue::NUMBER); break;
  default: return 1;  // G[
  }

  return 0;
}


// ---
//  ݂̂̕̕Rs[
// ---

int FormatParser::CopyString(const char *inBegin, const char *inEnd)
{
  if (MAX_TOKENS <= mTokenCount)
    return 1;
  TokenString  *theStr = new TokenString;
  mTokens[mTokenCount++] = theStr;
  theStr->SetString(inBegin, inEnd - inBegin);

  return 0;
}


// ----------------------------------------------------------------------------
//  eXgR[h
// ----------------------------------------------------------------------------

#ifdef TEST_FMTPARSER_CPP

#include <stdio.h>
#include <windows.h>

int main(void)
{
  FormatParser  theParser;
  theParser.Parse("clip_%2y.%m.%d_%H-%M-%S_No.%n");


  SYSTEMTIME  theSysTime;
  GetLocalTime(&theSysTime);

  WORD  theV;
  const Token  *theToken;
  const TokenString  *theStr;
  const TokenValue  *theVal;
  for (int theI = 0; theI < theParser.GetTokenCount(); theI++)
  {
    theToken = theParser.GetToken(theI);
    if (Token::STRING == theToken->GetTokenType())
    {
      theStr = (const TokenString *)theToken;
//      puts(theStr->GetString());
      printf("%s", theStr->GetString());
    }
    else
    {
      theVal = (const TokenValue *)theToken;
      switch (theVal->GetValueType())
      {
      case TokenValue::YEAR:   theV = theSysTime.wYear; break;
      case TokenValue::MONTH:  theV = theSysTime.wMonth; break;
      case TokenValue::DAY:    theV = theSysTime.wDay; break;
      case TokenValue::HOUR:   theV = theSysTime.wHour; break;
      case TokenValue::MINUTE: theV = theSysTime.wMinute; break;
      case TokenValue::SECOND: theV = theSysTime.wSecond; break;
      case TokenValue::NUMBER: theV = 1; break;
      }

      printf("%d", theV);
    }
  }

  return 0;
}

#endif
