// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  fmtparser.h
// ----------------------------------------------------------------------------

#ifndef _FMTPARSER_H_
#define _FMTPARSER_H_

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include <stdlib.h>


// ----------------------------------------------------------------------------
//  g[N
// ----------------------------------------------------------------------------

class Token
{
public:
  enum TokenType { STRING, VALUE };

  Token(TokenType inType) : mTokenType(inType) {}
  virtual ~Token() {}

  TokenType GetTokenType(void) const { return mTokenType; }

protected:
  TokenType  mTokenType;
};


// ----------------------------------------------------------------------------
//  g[N | 
// ----------------------------------------------------------------------------

class TokenString : public Token
{
  friend class FormatParser;

public:
  TokenString(void) : Token(Token::STRING) { mStr = NULL; }
  ~TokenString() { delete [] mStr; }

  const char *GetString(void) const { return mStr; }

private:
  void SetString(const char *inStr, int inLen)
  {
    delete [] mStr;
    mStr = new char [inLen + 1];

    const char  *theP = inStr;
    const char  *theEndP = inStr + inLen;
    int  theI;
    for (theI = 0; theP < theEndP; theI++)
    {
      if ('\0' == *theP)
        break;
      if ('%' == *theP && '%' == *(theP + 1))
        theP++;
      mStr[theI] = *theP++;
    }
    mStr[theI] = '\0';
  }

  char  *mStr;
};


// ----------------------------------------------------------------------------
//  g[N | l
// ----------------------------------------------------------------------------

class TokenValue : public Token
{
  friend class FormatParser;

public:
  enum ValueType
  {
    YEAR,
    MONTH,
    DAY,
    HOUR,
    MINUTE,
    SECOND,
    NUMBER,
    _DUMMY_
  };

  TokenValue(void) : Token(Token::VALUE) { mWidth = 0; mValType = _DUMMY_; }
  ~TokenValue() {}
  
  int GetWidth(void) const { return mWidth; }
  int GetValueType(void) const { return mValType; }

private:
  void SetWidth(int inWidth) { mWidth = inWidth; }
  void SetValueType(ValueType inValType) { mValType = inValType; }

  int        mWidth;
  ValueType  mValType;
};


// ----------------------------------------------------------------------------
//  ̉
// ----------------------------------------------------------------------------

class FormatParser
{
public:
  FormatParser(void);
  ~FormatParser();

  int Parse(const char *inFmt);

  int GetTokenCount(void) const { return mTokenCount; }
  const Token *GetToken(int inNo) const { return mTokens[inNo]; }

private:
  void FreeMem(void);

  enum { MAX_TOKENS = 32 };  // ܁Aꂭ炢őł傤 (^^;

  // NX
  int GetCharClass(int inC) const;
  class FormatCharClass  *mChrCls;
  
  int ParseFormField(const char* &ioStr);
  int CopyString(const char *inBegin, const char *inEnd);

  Token  *mTokens[MAX_TOKENS];
  int    mTokenCount;
};


#endif // _FMTPARSER_H_
