// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  fcg2gga - GGA Separator
//
//  Copyright (C) miyax 2001. All rights reserved.
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  main.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "fcg2gga.h"
#include "wndproc.h"


// ----------------------------------------------------------------------------
/// 萔
// ----------------------------------------------------------------------------

// EBhEX^C
#define APP_WINDOWSTYLE   WS_OVERLAPPEDWINDOW


// ----------------------------------------------------------------------------
//  vg^Cv錾
// ----------------------------------------------------------------------------

static int InitApp(HINSTANCE inInst);
static HWND InitWindow(void);
LRESULT CALLBACK
WndProc(HWND inWH, UINT inMsg, WPARAM inWP, LPARAM inLP);


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

HINSTANCE gInst;
static const char  *gCmdLine;


// ----------------------------------------------------------------------------
//  Gg|Cg
// ----------------------------------------------------------------------------

int WINAPI WinMain(HINSTANCE inInst, HINSTANCE inPrevInst,
                   LPSTR inCmdLine, int inCmdShow)
{
  if (FALSE == InitApp(inInst))
    return FALSE;
  gInst = inInst;
  gCmdLine = inCmdLine;

  HWND theWH = InitWindow();
  if (NULL == theWH)
    return FALSE;

  MSG  theMsg;
  while (GetMessage(&theMsg, NULL, 0, 0))
  {
    TranslateMessage(&theMsg);
    DispatchMessage(&theMsg);
  }

  return theMsg.wParam;
}


// ----------------------------------------------------------------------------
//  InitApp() - EBhENX̓o^
// ----------------------------------------------------------------------------

static int InitApp(HINSTANCE inInst)
{
  WNDCLASS theWndClass;

  theWndClass.style         = 0;
  theWndClass.lpfnWndProc   = WndProc;
  theWndClass.cbClsExtra    = 0;
  theWndClass.cbWndExtra    = 0;
  theWndClass.hInstance     = inInst;
  theWndClass.hIcon         = NULL;//LoadIcon(inInst, (LPCTSTR)IDI_ICON);
  theWndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  theWndClass.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
  theWndClass.lpszMenuName  = NULL;
  theWndClass.lpszClassName = APP_WNDCLASSNAME;

  return RegisterClass(&theWndClass);
}


// ----------------------------------------------------------------------------
//  InitWindow() - EBhE쐬
// ----------------------------------------------------------------------------

static HWND InitWindow(void)
{
  HWND theWH;

  theWH = CreateWindow(APP_WNDCLASSNAME, APP_WNDTITLE, APP_WINDOWSTYLE,
                       CW_USEDEFAULT, 0, 400, 240, NULL, NULL,
                       gInst, NULL);
  if (theWH != NULL)
  {
    ShowWindow(theWH, 1);
    UpdateWindow(theWH);
    DragAcceptFiles(theWH, TRUE);
  }

  return theWH;
}


// ----------------------------------------------------------------------------
//  WndProc() - EBhEvV[W
// ----------------------------------------------------------------------------

LRESULT CALLBACK
WndProc(HWND inWH, UINT inMsg, WPARAM inWP, LPARAM inLP)
{
  static WindowProc theWndProc;

  switch (inMsg)
  {
  case WM_CREATE:
    theWndProc.DoCreate(inWH);
    theWndProc.DoCommandLine(inWH, (LPARAM)gCmdLine);
    break;

  case WM_DESTROY:
    theWndProc.DoDestroy();
    break;

  case WM_DROPFILES:
    theWndProc.DoDropFiles(inWH, inWP);
    break;

  case WM_SIZE:
    theWndProc.DoSize(inWH, inLP);
    break;

  default:
    return DefWindowProc(inWH, inMsg, inWP, inLP);
  }

  return TRUE;
}
