// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  wndproc.cpp  2001/04/01
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "wndproc.h"
#include "fcg2gga.h"
#include "iterator.cxx"
#include "dropfile.h"
#include "cmdline.h"
#include "filenamegen.h"
#include <stdio.h>


// ----------------------------------------------------------------------------
//  萔
// ----------------------------------------------------------------------------

#define ID_EDIT  101


// ----------------------------------------------------------------------------
//  ^`
// ----------------------------------------------------------------------------

#pragma pack(1)

struct FCG_Header
{
  DWORD  mFileSize;
  DWORD  mFirstImagePosition;
  DWORD  mImageCount;
  WORD   mWidth;
  WORD   mHeight;
  DWORD  mPos1;
  DWORD  mSize1;
  BYTE   mUnknown[8];
};


struct ImageIndex
{
  DWORD  mHeaderPosition;
  DWORD  mImagePosition;
};


struct ImageHeader
{
  BYTE   mID[8];
  WORD   mWidth;
  WORD   mHeight;
  WORD   mUnknown1;
  BYTE   mColorBits;
  BYTE   mUnknown2;
  DWORD  mImagePos;
  DWORD  mImageSize;
  DWORD  mUnknownPos;
  DWORD  mUnknownSize;
  BYTE   mUnknown3[16];
};

#pragma pack()


// ----------------------------------------------------------------------------
//  vg^Cv錾
// ----------------------------------------------------------------------------

int FileCopy(FILE *outDst, FILE *inSrc, size_t inSize);


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

extern HINSTANCE  gInst;


// ----------------------------------------------------------------------------
//  DoCreate()
// ----------------------------------------------------------------------------

void WindowProc::DoCreate(HWND inWH)
{
  mEdit.SetInst(gInst);
  mEdit.Create(inWH, ID_EDIT);
  mEdit.AddText("FCG2GGA version " APP_VERSION_STR "\r\n");
  mEdit.AddText("Copyright (C) miyax 2002.\r\n\r\n");
  mEdit.AddText("Ƀt@ChbvI\r\n");
}


// ----------------------------------------------------------------------------
//  EBhE D&D ꂽt@C̏
// ----------------------------------------------------------------------------

void WindowProc::DoDropFiles(HWND inWH, WPARAM inWP)
{
  DroppedFiles  theDropFiles((HDROP)inWP);
  Iterator<DroppedFiles, const char *>  theDFItr(&theDropFiles);
  for (theDFItr.First(); !theDFItr.IsDone(); theDFItr.Next())
  {
    mEdit.AddText("\r\n---\r\n̓t@CF");
    mEdit.AddText(theDFItr.Current());
    mEdit.AddText("\r\n");
    Separate(theDFItr.Current());
  }
}


// ----------------------------------------------------------------------------
//  qEBhẼTCYύX
// ----------------------------------------------------------------------------

void WindowProc::DoSize(HWND inWH, LPARAM inLP)
{
  mEdit.Resize();
}


// ----------------------------------------------------------------------------
//  EBhEj
// ----------------------------------------------------------------------------

void WindowProc::DoDestroy(void)
{
  mEdit.Destroy();
  PostQuitMessage(0);
}


// ----------------------------------------------------------------------------
//  R}hCŎw肳Ăt@C
// ----------------------------------------------------------------------------

void WindowProc::DoCommandLine(HWND inWH, LPARAM inLP)
{
  CommandLine  theCmdLine((char *)inLP);
  Iterator  <CommandLine, const char *>  theCL_Itr(&theCmdLine);
  for (theCL_Itr.First(); !theCL_Itr.IsDone(); theCL_Itr.Next())
  {
    mEdit.AddText("\r\n---\r\n̓t@CF");
    mEdit.AddText(theCL_Itr.Current());
    mEdit.AddText("\r\n");
    Separate(theCL_Itr.Current());
  }
}


// ----------------------------------------------------------------------------
//  
// ----------------------------------------------------------------------------

int WindowProc::Separate(const char *inFileName)
{
  DWORD  theTime = GetTickCount();

  FILE  *theInFile = fopen(inFileName, "rb");
  if (NULL == theInFile)
  {
    mEdit.AddText("̓t@CJ܂ł\r\n");
    return 1;
  }

  FCG_Header  theHdr;
  fread(&theHdr, sizeof(FCG_Header), 1, theInFile);

  ImageIndex  *theIndex = new ImageIndex [theHdr.mImageCount];
  fread(theIndex, sizeof(ImageIndex), theHdr.mImageCount, theInFile);

  FileNameGenerator  theFNG;
  theFNG.SetExtension(".gg0");
  theFNG.SetFormat("fcg_%6n");

  for (DWORD theI = 0; theI < theHdr.mImageCount; theI++)
  {
    const char  *theOutName = theFNG.Generate();
    FILE  *theOutFile = fopen(theOutName, "wb");

    ImageHeader  theImgHdr;
    fseek(theInFile, theIndex[theI].mHeaderPosition + 4, SEEK_SET);
    fread(&theImgHdr, sizeof(ImageHeader), 1, theInFile);
    fwrite(&theImgHdr, sizeof(ImageHeader), 1, theOutFile);

    fseek(theInFile, theIndex[theI].mImagePosition, SEEK_SET);
    FileCopy(theOutFile, theInFile, theImgHdr.mImageSize);

    fclose(theOutFile);

    char  theText[1024];
    wsprintf(theText, "[%s]  TCYF%d\r\n",
             theOutName, sizeof(ImageHeader) + theImgHdr.mImageSize);
    mEdit.AddText(theText);
  }

  fclose(theInFile);

  theTime = GetTickCount() - theTime;

  {
    char  theBuf[512];
    wsprintf(theBuf, "ԁF%d.%03d b\r\n", theTime / 1000, theTime % 1000);
    mEdit.AddText(theBuf);
  }

  return 0;
}


// ---
//  t@C̕Rs[
// ---

int FileCopy(FILE *outDst, FILE *inSrc, size_t inSize)
{
  const int  BUF_SIZE = 512;
  char  theBuf[BUF_SIZE];

  size_t  theRemain = inSize;
  size_t  theCopySize;

  while (theRemain > 0)
  {
    theCopySize = (BUF_SIZE <= theRemain) ? BUF_SIZE : theRemain;

    fread(theBuf, 1, theCopySize, inSrc);
    fwrite(theBuf, 1, theCopySize, outDst);
    theRemain -= theCopySize;
  }

  return 0;
}

