// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  decoder.cpp  2002/02/10
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "decoder.h"
#include "util.h"


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

const char *gDescription = "GGA import plug-in ver.0.01 (C) miyax 2002.";

const char *gExtension[] = 
{
  "*.gg0;*.gg1",
};

const char *gFormatName[] = 
{
  "GGA file",
};

const int gFormatTypes = sizeof(gExtension) / sizeof(gExtension[0]);


// ----------------------------------------------------------------------------
//  GGA_Decoder
// ----------------------------------------------------------------------------

class GGA_Decoder : public Decoder
{
public:
  GGA_Decoder(void) {}
  ~GGA_Decoder() {}

  int IsSupportedFormat(Stream *inStrm);
  int GetPicInfo(PICTUREINFO &outPicInfo);
  int GetPalette(BYTE *outPal);
  int Decode(BYTE *outBMP, PluginProgress &ioProgress);

private:
#pragma pack(1)
  struct ImageHeader
  {
    BYTE   mID[8];
    WORD   mWidth;
    WORD   mHeight;
    WORD   mUnknown1;
    BYTE   mColorBits;
    BYTE   mUnknown2;
    DWORD  mImagePos;
    DWORD  mImageSize;
    DWORD  mUnknownPos;
    DWORD  mUnknownSize;
    BYTE   mUnknown3[16];
  };
#pragma pack()

  int ReadHeader(Stream *inStrm, ImageHeader &outHdr)
  {
    inStrm->Seek(0);
    return inStrm->GetBytes(&outHdr, sizeof(ImageHeader));
  }
};


// ---
//  ΉĂ`ׂ
// ---

int GGA_Decoder::IsSupportedFormat(Stream *inStrm)
{
  inStrm->Seek(0);

  // wb_ǂݍ݁A`FbN
  ImageHeader  theHdr;
  ReadHeader(inStrm, theHdr);
  if (0 != memcmp(theHdr.mID, "GGA00000", 8) ||
      0 == theHdr.mWidth || 0 == theHdr.mHeight ||
      0 != theHdr.mUnknown1 ||
      32 != theHdr.mColorBits ||
      sizeof(ImageHeader) > theHdr.mImagePos ||
      0 == theHdr.mImageSize ||
      theHdr.mUnknownSize + sizeof(ImageHeader) != theHdr.mImagePos ||
      sizeof(ImageHeader) != theHdr.mUnknownPos)
    return 0;
  else
    return 1;
}


// ---
//  PICTUREINFO 擾
// ---

int GGA_Decoder::GetPicInfo(PICTUREINFO &outPicInfo)
{
  // wb_ǂݍ
  ImageHeader  theHdr;
  ReadHeader(mInStrm, theHdr);

  memset(&outPicInfo, 0, sizeof(PICTUREINFO));
  outPicInfo.mWidth      = theHdr.mWidth;
  outPicInfo.mHeight     = theHdr.mHeight;
  outPicInfo.mColorDepth = (short)theHdr.mColorBits;

  return SPI_OK;
}

// ---
//  pbg擾
// ---

int GGA_Decoder::GetPalette(BYTE *outPal)
{
  return SPI_OK;
}


// ---
//  WJ
// ---

int GGA_Decoder::Decode(BYTE *outBMP, PluginProgress &Progress)
{
  // wb_ǂݍ
  ImageHeader  theHdr;
  ReadHeader(mInStrm, theHdr);

  // WJobt@̃TCYvZ
  DWORD  theLineBytes = WIDTHBYTES(theHdr.mWidth, theHdr.mColorBits);//theHdr.mWidth * theHdr.mColorBits / 8;
  DWORD  theTmpSize = theLineBytes * theHdr.mHeight;

  // WJobt@mۂ
  BYTE  *theTmp = new BYTE [theTmpSize];
  BYTE  *theTmpP = theTmp;
  BYTE  *theTmpEnd = theTmpP + theTmpSize;

  // WJ[v
  int  theC, theLen, theDist, theI;
  mInStrm->Seek(theHdr.mImagePos);
  while (theTmpP < theTmpEnd &&
         Stream::EOS != (theC = mInStrm->GetByte()))
  {
    if (theC >= 0x0C)  // ksNZ̉
    {
      theLen = (theC - 0x0B) * 4;
      if (theTmpP + theLen >= theTmpEnd)
        theLen = theTmpEnd - theTmpP;
      mInStrm->GetBytes(theTmpP, theLen);
      theTmpP += theLen;
    }
    else if (theC <= 0x01)  // OX
    {
      if (0x00 == theC)  // PoCg
        theLen = mInStrm->GetByte();
      else  // QoCg
        mInStrm->GetBytes(&theLen, 2);

      for (theI = 0; theI < theLen; theI++)
      {
        memcpy(theTmpP, theTmpP - 4, 4);
        theTmpP += 4;
        if (theTmpP >= theTmpEnd)
          break;
      }
    }
    else if (theC <= 0x03)  // PsNZRs[
    {
      if (0x02 == theC)  // PoCg
        theDist = mInStrm->GetByte();
      else  // QoCg
      {
        mInStrm->GetBytes(&theDist, 2);
        theDist &= 0xFFFF;
      }

      memcpy(theTmpP, theTmpP - (theDist << 2), 4);
      theTmpP += 4;
    }
    else if (theC <= 0x07)  // XChRs[
    {
      // ǂݍ
      if (0x04 == theC || 0x05 == theC)  // 0x04, 0x05  PoCg
        theDist = mInStrm->GetByte();
      else  // 0x06, 0x07  QoCg
      {
        mInStrm->GetBytes(&theDist, 2);
        theDist &= 0xFFFF;
      }
      theDist <<= 2;

      // Rs[ǂݍ
      if (0x04 == theC || 0x06 == theC)  // 0x04, 0x06  Rs[PoCg
        theLen = mInStrm->GetByte();
      else  // 0x05, 0x07  Rs[QoCg
        mInStrm->GetBytes(&theLen, 2);

      for (theI = 0; theI < theLen; theI++)
      {
        memcpy(theTmpP, theTmpP - theDist, 4);
        theTmpP += 4;
        if (theTmpP >= theTmpEnd)
          break;
      }
    }
    else  // 0x09 - 0x0B
    {
      if (0x09 == theC)
        theDist = theLineBytes;
      else if (0x0A == theC)
        theDist = theLineBytes + 4;
      else if (0x0B == theC)
        theDist = theLineBytes - 4;
      memcpy(theTmpP, theTmpP - theDist, 4);
      theTmpP += 4;
    }
  }

  // C[W㉺]ďo͂
  {
    DWORD  theDstLineBytes = WIDTHBYTES(theHdr.mWidth, theHdr.mColorBits);
    for (DWORD theI = 0; theI < theHdr.mHeight; theI++)
    {
      memcpy(outBMP + (theHdr.mHeight - 1 - theI) * theDstLineBytes,
             theTmp + theI * theLineBytes, theLineBytes);
    }
  }
  delete [] theTmp;

  return SPI_OK;
}


// ----------------------------------------------------------------------------
//  tH[}bg̎ʂ𒲂ׂ
//
//  ߂lFOȏ  ΉtH[}bgiʔԍj
//          O  Ή
// ----------------------------------------------------------------------------

int GetFormatType(Stream *inStrm)
{
  int  theRet;
  Decoder  *theDecoder;

  theDecoder = new GGA_Decoder;
  theRet = theDecoder->IsSupportedFormat(inStrm);
  delete theDecoder;
  if (theRet)
    return 1;

  return 0;
}


// ----------------------------------------------------------------------------
//  DecoderFactory
// ----------------------------------------------------------------------------

// ---
//  Create() - fR[_𐶐
// ---

Decoder *DecoderFactory::Create(int inFormatNo)
{
  if (1 == inFormatNo)
    return new GGA_Decoder;
  else
    return NULL;
}
