// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  m_stream.h  2002/01/27
// ----------------------------------------------------------------------------

#ifndef _M_STREAM_H_
#define _M_STREAM_H_

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include <windows.h>


namespace m_stream
{

// ----------------------------------------------------------------------------
//  (FactoryMethod Product)
// ----------------------------------------------------------------------------

class Stream
{
public:
  Stream(void) {}
  virtual ~Stream() {}

  virtual int OpenIn(const void *inData, DWORD inDataLen) = 0;
  virtual int OpenOut(const void *inData, DWORD inDataLen) = 0;
  virtual int OpenInOut(const void *inData, DWORD inDataLen) = 0;
  
  virtual void Close(void) = 0;

  virtual int GetByte(void) = 0;
  virtual int PutByte(int inC) = 0;

  virtual int GetBytes(void *outBuf, DWORD inLen) = 0;
  virtual int PutBytes(const void *inBuf, DWORD inLen) = 0;
  virtual int PutBytes(Stream *inSrc, DWORD inLen) = 0;

  virtual int Seek(DWORD inPos) = 0;
  virtual DWORD Tell(void) = 0;
  virtual DWORD GetLen(void) = 0;

  virtual int IsEndOfStream(void) = 0;

  enum
  {
    EOS = -1
  };

protected:
};


// ----------------------------------------------------------------------------
//  (FactoryMethod Factory)
// ----------------------------------------------------------------------------

class StreamFactory
{
public:
  StreamFactory(void) {}
  virtual ~StreamFactory() {}

  virtual Stream *Create(void) = 0;
};


// ----------------------------------------------------------------------------
//  t@Co̓NX쐬NX (Concrete Factory)
// ----------------------------------------------------------------------------

class StreamWinFileFactory : public StreamFactory
{
public:
  StreamWinFileFactory(void) {}
  ~StreamWinFileFactory() {}

  Stream *Create(void);
};

class StreamWinHandleFactory : public StreamFactory
{
public:
  StreamWinHandleFactory(void) {}
  ~StreamWinHandleFactory() {}

  Stream *Create(void);
};


// ----------------------------------------------------------------------------
//  o̓NX쐬NX (Concrete Factory)
// ----------------------------------------------------------------------------

class StreamMemoryFactory : public StreamFactory
{
public:
  StreamMemoryFactory(void) {}
  ~StreamMemoryFactory() {}

  Stream *Create(void);
};

} // namespace m_stream

#endif // _M_STREAM_H_
