// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  decoder.h  2002/01/27
// ----------------------------------------------------------------------------

#ifndef _DECODER_H_
#define _DECODER_H_

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "spi.h"
#include "progress.h"
#include "m_stream.h"

using namespace m_stream;


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

extern const char *gDescription;
extern const char *gExtension[];
extern const char *gFormatName[];
extern const int  gFormatTypes;


// ----------------------------------------------------------------------------
//  vg^Cv錾
// ----------------------------------------------------------------------------

int GetFormatType(Stream *inStrm);


// ----------------------------------------------------------------------------
//  摜fR[_
// ----------------------------------------------------------------------------

class Decoder
{
public:
  Decoder(void) { mInStrm = NULL; }
  virtual ~Decoder() {}

  virtual void SetInStream(Stream *inStrm) { mInStrm = inStrm; }

  virtual int  IsSupportedFormat(Stream *inStrm) = 0;
  virtual int  GetPicInfo(PICTUREINFO &outPicInfo) = 0;
  virtual int  GetPalette(BYTE *outPal) = 0;
  virtual int  Decode(BYTE *outBMP, PluginProgress &ioProgress) = 0;

protected:
  Stream  *mInStrm;
};


// ----------------------------------------------------------------------------
//  Decoder ̐NX
// ----------------------------------------------------------------------------

class DecoderFactory
{
public:
  DecoderFactory(void) {}
  ~DecoderFactory() {}

  Decoder *Create(int inFormatNo);
};


#endif // _DECODER_H_
