// -*- Mode: C -*-

// ----------------------------------------------------------------------------
//  spi.h  2002/01/27
// ----------------------------------------------------------------------------

#ifndef _SPI_H_
#define _SPI_H_

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include <windows.h>
#include <time.h>


// ----------------------------------------------------------------------------
//  }N
// ----------------------------------------------------------------------------

// GetPictureInfo/GetPicture/GetArchiveInfo/GetFileInfo/GetFile ̓o
#define GET_INPUT_TYPE(x) ((x) & 0x07)
#define GET_OUTPUT_TYPE(x) ((x) & 0x0700)

// QoCgf[^̃GfBAϊ
#define SWAP_WORD(x) ((((x) << 8) & 0xFF00) | (((x) >> 8) & 0xFF))

// SoCgf[^̃GfBAϊ
#define SWAP_DWORD(x)  ((((x) << 24) & 0xFF000000UL) | \
                        (((x) << 8)  & 0x00FF0000UL) | \
                        (((x) >> 8)  & 0x0000FF00UL) | \
                        (((x) >> 24) & 0x000000FFUL))


// ----------------------------------------------------------------------------
//  萔
// ----------------------------------------------------------------------------

// ----- G[R[h -----
#define SPI_ERROR_SUCCEED            0  // I
#define SPI_ERROR_NOT_IMPLEMENT     -1  // ĂȂ@\
#define SPI_ERROR_CANCEL             1  // WJLZ
#define SPI_ERROR_UNKNOWN_FORMAT     2  // m̃t@C`
#define SPI_ERROR_BROKEN_DATA        3  // f[^Ă
#define SPI_ERROR_MEMORY_ALLOCATION  4  // [mۂłȂ
#define SPI_ERROR_MEMORY             5  // [֘ÃG[
#define SPI_ERROR_FILE_READ          6  // t@Cǂݍ݃G[
#define SPI_ERROR_ERROR              8  // G[
#define SPI_ERROR_FILE_WRITE         9  // t@C݃G[

#define SPI_OK      SPI_ERROR_SUCCEED
#define SPI_CANCEL  SPI_ERROR_CANCEL


// ----- ͌` -----
// t@C (t@C, ItZbg)
#define SPI_INPUT_DISKFILE  0x00000000

// 
#define SPI_INPUT_MEMORY    0x00000001


// ----- o͌` -----
#define SPI_OUTPUT_DISKFILE  0x00000000  // t@Co
#define SPI_OUTPUT_MEMORY    0x00010000  // o


// ----------------------------------------------------------------------------
//  \
// ----------------------------------------------------------------------------

#pragma pack(1)

// 摜
typedef struct
{
  long    mLeft, mTop;
  long    mWidth;
  long    mHeight;
  WORD    mX_Density;
  WORD    mY_Density;
  short   mColorDepth;
  HLOCAL  mText;
} PICTUREINFO;

// A[JCuf[^
typedef struct
{
  unsigned char  mMethodName[8];
  unsigned long  mPosition;
  unsigned long  mCompressedSize;
  unsigned long  mOriginalSize;
  time_t         mTimeStamp;
  char           mPath[200];
  char           mFileName[200];
  unsigned long  mCRC;
} FILEINFO;

#pragma pack()


// i
typedef int (CALLBACK *SPI_PROGRESS)(int, int, long);


// ----------------------------------------------------------------------------
//  vg^Cv錾
// ----------------------------------------------------------------------------

// Susie plug-in API

#define SPIEXPORT __declspec(dllexport) WINAPI

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

// 
int SPIEXPORT GetPluginInfo(int inInfoNo, LPSTR outBuff, int inBuffLen);
int SPIEXPORT IsSupported(LPSTR inFileName, DWORD inData);
int SPIEXPORT ConfigurationDlg(HWND inParent, int inFunc);

// 摜WJ
int SPIEXPORT GetPictureInfo(LPSTR inBuff, long inBuffLen, unsigned int inFlag,
                             PICTUREINFO *outPicInfo);
int SPIEXPORT GetPicture(LPSTR inBuff, long inBuffLen, unsigned int inFlag,
                         HANDLE *outBMInfo, HANDLE *outBMP,
                         SPI_PROGRESS Progress, long inData);
int SPIEXPORT GetPreview(LPSTR inBuff, long inBuffLen, unsigned int inFlag,
                         HANDLE *outBMInfo, HANDLE *outBMP,
                         SPI_PROGRESS Progress, long inData);

// A[JCuo
int SPIEXPORT GetArchiveInfo(LPSTR inBuff, long inLen, unsigned int inFlag,
                             HLOCAL *outFileInfo);
int SPIEXPORT GetFileInfo(LPSTR inBuff, long inLen, LPSTR inFileName,
                          unsigned int inFlag, FILEINFO *outFileInfo);
int SPIEXPORT GetFile(LPSTR inSrc, long inLen, LPSTR ioDst, unsigned int inFlag,
                      SPI_PROGRESS Progress, long inData);


#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _SPI_H_
