// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  spi_in_main.cpp  2002/01/30
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "spi.h"
#include "util.h"
#include "m_stream.h"
#include "progress.h"
#include "decoder.h"
#include "param.h"

#ifdef ENABLE_CONFIGDLG
#include "config.h"
#include "dlgproc.h"
#endif // ENABLE_CONFIGDLG

using namespace m_stream;


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

#ifdef ENABLE_CONFIGDLG
extern const char  *gPluginRegKey;
extern Config      *gCfg;
HINSTANCE  gInst;
#endif // ENABLE_CONFIGDLG


// ----------------------------------------------------------------------------
//  vg^Cv錾
// ----------------------------------------------------------------------------

static int InitStream(Stream* &outStrm, SpiParam *inParam);


// ----------------------------------------------------------------------------
//  Gg|Cg
// ----------------------------------------------------------------------------

#ifdef ENABLE_CONFIGDLG
BOOL WINAPI DllMain(HINSTANCE inInst,
                    DWORD     inReason,
                    LPVOID    inReserved)
{
  switch (inReason)
  {
  case DLL_PROCESS_ATTACH:
    InitPlugin();
    gCfg->Load(gPluginRegKey);
    ResetPlugin();
    gInst = inInst;
    break;

  case DLL_PROCESS_DETACH:
    EndPlugin();
    break;

  default:
    return FALSE;
  }

  return TRUE;
}
#endif // ENABLE_CONFIGDLG


// ----------------------------------------------------------------------------
//  
// ----------------------------------------------------------------------------

static int InitStream(Stream* &outStrm, SpiParam *inParam)
{
  outStrm = NULL;

  Stream  *theStrm;
  int  theInType = inParam->Flags(FLAG_INPUT_TYPE);
  if (SPI_INPUT_DISKFILE == theInType)
  {
    StreamWinFileFactory  theFactory;
    theStrm = theFactory.Create();
    if (NULL == theStrm)
      return SPI_ERROR_MEMORY_ALLOCATION;
    if (0 != theStrm->OpenIn(inParam->InBuf(), 0))
    {
      delete theStrm;
      return SPI_ERROR_FILE_READ;
    }
    theStrm->Seek(inParam->InBufLen());
  }
  else if (SPI_INPUT_MEMORY == theInType)
  {
    StreamMemoryFactory  theFactory;
    theStrm = theFactory.Create();
    if (NULL == theStrm)
      return SPI_ERROR_MEMORY_ALLOCATION;
    theStrm->OpenIn(inParam->InBuf(), inParam->InBufLen());
  }
  else
    return SPI_ERROR_NOT_IMPLEMENT;

  outStrm = theStrm;
  return SPI_OK;
}


// ----------------------------------------------------------------------------
//  GetPicture ̈ێNX
// ----------------------------------------------------------------------------

class GetPictureParam : public SpiParam
{
public:
  GetPictureParam(LPSTR inBuf, long inBufLen, unsigned int inFlags,
                  HANDLE *outBMI, HANDLE *outBMP,
                  SPI_PROGRESS Progress, long inData)
       : SpiParam(inBuf, inBufLen, inFlags)
  {
    mOutBMI = outBMI;
    mOutBMP = outBMP;
    mProgressFunc = Progress;
    mProgressData = inData;
  }
  ~GetPictureParam() {}


  HANDLE *OutBMI(void) { return mOutBMI; }
  HANDLE *OutBMP(void) { return mOutBMP; }
  SPI_PROGRESS Progress(void) { return mProgressFunc; }
  long ProgressData(void) { return mProgressData; }

private:
  HANDLE        *mOutBMI;
  HANDLE        *mOutBMP;
  SPI_PROGRESS  mProgressFunc;
  long          mProgressData;
};


// ----------------------------------------------------------------------------
//  摜擾
// ----------------------------------------------------------------------------

class GetPictureTemplate
{
public:
  GetPictureTemplate(GetPictureParam &inParam);
  ~GetPictureTemplate();

  int GetPic(void);

private:
  int InitInStream(void);
  int InitDecoder(void);
  int AllocOutBuf(void);
  int Decode(void);
  int ErrorExit(int inErrCode);

  GetPictureParam  &mParam;

  Stream   *mInStrm;
  Decoder  *mDec;
  HANDLE   mBMIHandle;
  HANDLE   mBMPHandle;
};


// ----------------------------------------------------------------------------
//  GetPictureTemplate RXgN^EfXgN^
// ----------------------------------------------------------------------------

GetPictureTemplate::GetPictureTemplate(GetPictureParam &inParam)
     : mParam(inParam)
{
  mInStrm = NULL;
  mDec = NULL;
  mBMIHandle = NULL;
  mBMPHandle = NULL;
}

GetPictureTemplate::~GetPictureTemplate()
{
  ErrorExit(SPI_OK);
}


// ----------------------------------------------------------------------------
//  vOC GetPicture() ւ̃C^[tFCX
// ----------------------------------------------------------------------------

int GetPictureTemplate::GetPic(void)
{
  int  theRet;
  if (0 != (theRet = InitInStream()))
    goto ERROR_EXIT;
  if (0 != (theRet = InitDecoder()))
    goto ERROR_EXIT;
  if (0 != (theRet = AllocOutBuf()))
    goto ERROR_EXIT;
  if (0 != (theRet = Decode()))
    goto ERROR_EXIT;

  *(mParam.OutBMI()) = mBMIHandle;
  *(mParam.OutBMP()) = mBMPHandle;

ERROR_EXIT:
  return ErrorExit(theRet);
}


// ----------------------------------------------------------------------------
//  ̓Xg[
// ----------------------------------------------------------------------------

int GetPictureTemplate::InitInStream(void)
{
  return InitStream(mInStrm, &mParam);
}


// ----------------------------------------------------------------------------
//  摜fR[_
// ----------------------------------------------------------------------------

int GetPictureTemplate::InitDecoder(void)
{
  // fR[_𐶐
  DecoderFactory  theDecFactory;
  Decoder  *theDec = theDecFactory.Create(GetFormatType(mInStrm));
  if (NULL == theDec)
    return SPI_ERROR_MEMORY_ALLOCATION;

  // fR[_
  theDec->SetInStream(mInStrm);
  mDec = theDec;

  return SPI_OK;
}


// ----------------------------------------------------------------------------
//  o̓f[^̃mۂ
// ----------------------------------------------------------------------------

int GetPictureTemplate::AllocOutBuf(void)
{
  PICTUREINFO  thePicInfo;
  mDec->GetPicInfo(thePicInfo);  // t@X

  // 摜f[^̃mۂ
  DWORD  theImageSize = WIDTHBYTES(thePicInfo.mWidth, thePicInfo.mColorDepth) *
                        thePicInfo.mHeight;
  HANDLE  theBMPHandle = LocalAlloc(LHND, theImageSize);
  if (NULL == theBMPHandle)
    return SPI_ERROR_MEMORY_ALLOCATION;

  // BITMAPINFO ̃mۂ
  DWORD  thePalSize = CalcPalSize(thePicInfo.mColorDepth);
  HANDLE  theBMIHandle = LocalAlloc(LHND, sizeof(BITMAPINFO) + thePalSize);
  if (NULL == theBMIHandle)
  {
    LocalFree(theBMPHandle);
    return SPI_ERROR_MEMORY_ALLOCATION;
  }

  mBMPHandle = theBMPHandle;
  mBMIHandle = theBMIHandle;

  return SPI_OK;
}


// ----------------------------------------------------------------------------
//  摜WJ
// ----------------------------------------------------------------------------

int GetPictureTemplate::Decode(void)
{
  PICTUREINFO  thePicInfo;
  mDec->GetPicInfo(thePicInfo);  // t@X

  PluginProgress  theProgress(mParam.Progress(), mParam.ProgressData());

  // 摜WJ
  BYTE *theBMP = (BYTE *)LocalLock(mBMPHandle);
  int theRet = mDec->Decode(theBMP, theProgress);
  LocalUnlock(mBMPHandle);
  if (SPI_OK != theRet)
    return theRet;

  // BITMAPINFO ɒl
  BITMAPINFOHEADER  *theBI = (BITMAPINFOHEADER *)LocalLock(mBMIHandle);
  theBI->biSize = sizeof(BITMAPINFOHEADER);
  theBI->biWidth = thePicInfo.mWidth;
  theBI->biHeight = thePicInfo.mHeight;
  theBI->biBitCount = thePicInfo.mColorDepth;
  theBI->biPlanes = 1;

  // pbgȂ擾
  if (8 >= thePicInfo.mColorDepth)
  {
    BYTE  *thePal = (BYTE *)theBI + sizeof(BITMAPINFOHEADER);
    mDec->GetPalette(thePal);
  }
  LocalUnlock(mBMIHandle);

  return SPI_OK;
}


// ----------------------------------------------------------------------------
//  GetPicture() ̃G[EǏЕt
// ----------------------------------------------------------------------------

int GetPictureTemplate::ErrorExit(int inErrCode)
{
  if (NULL != mInStrm)
  {
    delete mInStrm;
    mInStrm = NULL;
  }
  if (NULL != mDec)
  {
    delete mDec;
    mDec = NULL;
  }
  if (NULL != mBMIHandle)
  {
    if (SPI_OK != inErrCode)
      LocalFree(mBMIHandle);
    mBMIHandle = NULL;
  }
  if (NULL != mBMPHandle)
  {
    if (SPI_OK != inErrCode)
      LocalFree(mBMPHandle);
    mBMPHandle = NULL;
  }
  return inErrCode;
}


// ----------------------------------------------------------------------------
//  Susie plug-in API
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  GetPluginInfo() - vOC̏擾
// ----------------------------------------------------------------------------

int WINAPI GetPluginInfo(int inInfoNo, LPSTR outBuf, int inBufLen)
{
  if (0 > inInfoNo || NULL == outBuf || 0 == inBufLen)
    return 0;

  int  theRet = 0;
  if (0 == inInfoNo)  // API o[W
    theRet = StrNCopy(outBuf, "00IN", inBufLen);
  else if (1 == inInfoNo)  // vOC̃o[W
    theRet = StrNCopy(outBuf, gDescription, inBufLen);
  else
  {
    int  theFormatNo = (inInfoNo >> 1) - 1;
    if (theFormatNo < gFormatTypes)
    {
      if (0 == (inInfoNo & 0x01))  // gq
        theRet = StrNCopy(outBuf, gExtension[theFormatNo], inBufLen);
      else  // t@C`
        theRet = StrNCopy(outBuf, gFormatName[theFormatNo], inBufLen);
    }
  }

  return theRet;
}


// ----------------------------------------------------------------------------
//  IsSupported() - ΉĂ`𒲂ׂ
// ----------------------------------------------------------------------------

int WINAPI IsSupported(LPSTR inFileName, DWORD inData)
{
  // ܂́Anꂽf[^ɂ Factory 쐬
  StreamFactory  *theStrmFactory;
  if (0 == (0xFFFF0000 & inData))
    theStrmFactory = new StreamWinHandleFactory;
  else
    theStrmFactory = new StreamMemoryFactory;

  // ɍ쐬ꂽ Factory  Stream 쐬
  Stream  *theCheckData = theStrmFactory->Create();
  delete theStrmFactory;

  // Xg[
  theCheckData->OpenIn((char *)inData, 1024);


  // `FbN
  int theRet = GetFormatType(theCheckData);

  // Еt
  delete theCheckData;

  return theRet;
}


// ----------------------------------------------------------------------------
//  GetPictureInfo()
// ----------------------------------------------------------------------------

int WINAPI GetPictureInfo(LPSTR inBuf, long inBufLen, unsigned int inFlags,
                          PICTUREINFO *outPicInfo)
{
  SpiParam  theParam(inBuf, inBufLen, inFlags);

  // ̓Xg[
  Stream  *theInStrm;
  int  theRet = InitStream(theInStrm, &theParam);
  if (SPI_OK != theRet)
    return theRet;

  // fR[_쐬
  DecoderFactory  theDecFactory;
  Decoder  *theDec = theDecFactory.Create(GetFormatType(theInStrm));
  if (NULL == theDec)
  {
    delete theInStrm;
    return SPI_ERROR_MEMORY_ALLOCATION;
  }

  // PICTUREINFO 擾
  theDec->SetInStream(theInStrm);
  theRet = theDec->GetPicInfo(*outPicInfo);

  delete theDec;
  delete theInStrm;

  return theRet;
}


// ----------------------------------------------------------------------------
//  GetPicture()
// ----------------------------------------------------------------------------

int WINAPI GetPicture(LPSTR inBuf, long inBufLen, unsigned int inFlags,
                      HANDLE *outBMInfo, HANDLE *outBMP,
                      SPI_PROGRESS Progress, long inData)
{
  GetPictureParam  theParam(inBuf, inBufLen, inFlags, outBMInfo,
                            outBMP, Progress, inData);
  GetPictureTemplate  theGetPicture(theParam);
  return theGetPicture.GetPic();
}


int WINAPI GetPreview(LPSTR inBuf, long inBufLen, unsigned int inFlags,
                      HANDLE *outBMInfo, HANDLE *outBMP,
                      SPI_PROGRESS Progress, long inData)
{
  return SPI_ERROR_NOT_IMPLEMENT;
}

// ----------------------------------------------------------------------------
//  ConfigurationDlg()
// ----------------------------------------------------------------------------

#ifdef ENABLE_CONFIGDLG
int WINAPI ConfigurationDlg(HWND inParent, int inFunc)
{
  if (0 == inFunc)
    MessageBox(inParent, gDescription, "vOC̏", MB_OK);
  else if (1 == inFunc)
  {
    DialogBox(gInst, MAKEINTRESOURCE(IDD_CONFIG), inParent, (DLGPROC)DlgProc);
    gCfg->Save(gPluginRegKey);
    ResetPlugin();
  }
  else
    return SPI_ERROR_ERROR;
  return SPI_OK;
}
#endif // ENABLE_CONFIGDLG
