// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  spi_am_main.cpp  2002/01/30
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "spi.h"
#include "util.h"
#include "m_stream.h"
#include "progress.h"
#include "param.h"
#include "archiver.h"

#ifdef ENABLE_CONFIGDLG
#include "config.h"
#include "dlgproc.h"
#endif // ENABLE_CONFIGDLG

using namespace m_stream;


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

#ifdef ENABLE_CONFIGDLG
extern const char  *gPluginRegKey;
extern Config      *gCfg;
HINSTANCE  gInst;
#endif // ENABLE_CONFIGDLG


// ----------------------------------------------------------------------------
//  vg^Cv錾
// ----------------------------------------------------------------------------

//static int InitStream(Stream* &outStrm, SpiParam *inParam);


// ----------------------------------------------------------------------------
//  Gg|Cg
// ----------------------------------------------------------------------------

#ifdef ENABLE_CONFIGDLG
BOOL WINAPI DllMain(HINSTANCE inInst,
                    DWORD     inReason,
                    LPVOID    inReserved)
{
  switch (inReason)
  {
  case DLL_PROCESS_ATTACH:
    InitPlugin();
    gCfg->Load(gPluginRegKey);
    ResetPlugin();
    gInst = inInst;
    break;

  case DLL_PROCESS_DETACH:
    EndPlugin();
    break;

  default:
    return FALSE;
  }

  return TRUE;
}
#endif // ENABLE_CONFIGDLG


// ----------------------------------------------------------------------------
//  
// ----------------------------------------------------------------------------
/*
static int InitStream(Stream* &outStrm, SpiParam *inParam)
{
  outStrm = NULL;

  Stream  *theStrm;
  int  theInType = inParam->Flags(FLAG_INPUT_TYPE);
  if (SPI_INPUT_DISKFILE == theInType)
  {
    StreamWinFileFactory  theFactory;
    theStrm = theFactory.Create();
    if (NULL == theStrm)
      return SPI_ERROR_MEMORY_ALLOCATION;
    if (0 != theStrm->OpenIn(inParam->InBuf(), 0))
    {
      delete theStrm;
      return SPI_ERROR_FILE_READ;
    }
    theStrm->Seek(inParam->InBufLen());
  }
  else if (SPI_INPUT_MEMORY == theInType)
  {
    StreamMemoryFactory  theFactory;
    theStrm = theFactory.Create();
    if (NULL == theStrm)
      return SPI_ERROR_MEMORY_ALLOCATION;
    theStrm->OpenIn(inParam->InBuf(), inParam->InBufLen());
  }
  else
    return SPI_ERROR_NOT_IMPLEMENT;

  outStrm = theStrm;
  return SPI_OK;
}
*/

// ----------------------------------------------------------------------------
//  Susie plug-in 00AM API
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  GetPluginInfo() - vOC̏擾
// ----------------------------------------------------------------------------

int WINAPI GetPluginInfo(int inInfoNo, LPSTR outBuf, int inBufLen)
{
  if (0 > inInfoNo || NULL == outBuf || 0 == inBufLen)
    return 0;

  int  theRet = 0;
  if (0 == inInfoNo)  // API o[W
    theRet = StrNCopy(outBuf, "00AM", inBufLen);
  else if (1 == inInfoNo)  // vOC̃o[W
    theRet = StrNCopy(outBuf, gDescription, inBufLen);
  else
  {
    int  theFormatNo = (inInfoNo >> 1) - 1;
    if (theFormatNo < gFormatTypes)
    {
      if (0 == (inInfoNo & 0x01))  // gq
        theRet = StrNCopy(outBuf, gExtension[theFormatNo], inBufLen);
      else  // t@C`
        theRet = StrNCopy(outBuf, gFormatName[theFormatNo], inBufLen);
    }
  }

  return theRet;
}


// ----------------------------------------------------------------------------
//  IsSupported() - ΉĂ`𒲂ׂ
// ----------------------------------------------------------------------------

int WINAPI IsSupported(LPSTR inFileName, DWORD inData)
{
  // ܂́Anꂽf[^ɂ Factory 쐬
  StreamFactory  *theStrmFactory;
  if (0 == (0xFFFF0000 & inData))
    theStrmFactory = new StreamWinHandleFactory;
  else
    theStrmFactory = new StreamMemoryFactory;

  // ɍ쐬ꂽ Factory  Stream 쐬
  Stream  *theCheckData = theStrmFactory->Create();
  delete theStrmFactory;

  // Xg[
  theCheckData->OpenIn((char *)inData, 1024);

  // `FbN
  int theRet = GetFormatType(inFileName, theCheckData);

  // Еt
  delete theCheckData;

  return theRet;
}


// ----------------------------------------------------------------------------
//  GetArchiveInfo()
// ----------------------------------------------------------------------------

int WINAPI GetArchiveInfo(LPSTR inBuf, long inBufLen, unsigned int inFlags,
                          HLOCAL *outFileInfo)
{
  SpiParam  theParam(inBuf, inBufLen, inFlags);

  // t@C͈ȊO͎󂯕tȂ
  if (SPI_INPUT_DISKFILE != theParam.Flags(FLAG_INPUT_TYPE))
    return SPI_ERROR_NOT_IMPLEMENT;

  // A[JCo𐶐
  ArchiverFactory  theArcFactory;
  Archiver  *theArc = theArcFactory.Create(GetFormatType(inBuf, NULL));
  if (NULL == theArc)
    return SPI_ERROR_MEMORY_ALLOCATION;

  // A[JCuJ
  int theRet = theArc->Open(inBuf);
  if (SPI_OK != theRet)
  {
    delete theArc;
    return SPI_ERROR_FILE_READ;
  }

  // t@C擾
  DWORD  theFileCount = theArc->GetFileCount();

  *outFileInfo = LocalAlloc(LMEM_MOVEABLE,
                            (theFileCount + 1) * sizeof(FILEINFO));
  if (NULL == *outFileInfo)
  {
    delete theArc;
    return SPI_ERROR_MEMORY_ALLOCATION;
  }

  FILEINFO  *theFileInfo = (FILEINFO *)LocalLock(*outFileInfo);
  for (DWORD theI = 0; theI < theFileCount; theI++)
    theArc->GetArcFileInfo(theI, theFileInfo + theI);
  theFileInfo[theFileCount].mMethodName[0] = '\0';
  LocalUnlock(*outFileInfo);

  delete theArc;

  return SPI_OK;
}


// ----------------------------------------------------------------------------
//  GetFileInfo()
// ----------------------------------------------------------------------------

int WINAPI GetFileInfo(LPSTR inBuf, long inBufLen, LPSTR inFileName,
                       unsigned int inFlags, FILEINFO *outFileInfo)
{
  SpiParam  theParam(inBuf, inBufLen, inFlags);

  // t@C͈ȊO͎󂯕tȂ
  if (SPI_INPUT_DISKFILE != theParam.Flags(FLAG_INPUT_TYPE))
    return SPI_ERROR_NOT_IMPLEMENT;

  // A[JCo𐶐
  ArchiverFactory  theArcFactory;
  Archiver  *theArc = theArcFactory.Create(GetFormatType(inBuf, NULL));
  if (NULL == theArc)
    return SPI_ERROR_MEMORY_ALLOCATION;

  // A[JCuJ
  int theRet = theArc->Open(inBuf);
  if (SPI_OK != theRet)
  {
    delete theArc;
    return SPI_ERROR_FILE_READ;
  }

  StrCmpFunc  theStrCmp = (SPI_IGNORE_CASE == theParam.Flags(FLAG_COMPARE_MODE)) ? stricmp : strcmp;

  theRet = theArc->GetArcFileInfo(inFileName, theStrCmp, outFileInfo);
  delete theArc;

  return theRet;
}


// ----------------------------------------------------------------------------
//  GetFile()
// ----------------------------------------------------------------------------

int WINAPI GetFile(LPSTR inSrc, long inLen, LPSTR ioDst, unsigned int inFlags,
                   SPI_PROGRESS Progress, long inData)
{
  SpiParam  theParam(inSrc, inLen, inFlags);

  if (NULL != Progress)
    Progress(0, 1, inData);

  // t@C͈ȊO͎󂯕tȂ
  if (SPI_INPUT_DISKFILE != theParam.Flags(FLAG_INPUT_TYPE) ||
      SPI_OUTPUT_MEMORY != theParam.Flags(FLAG_OUTPUT_TYPE))
    return SPI_ERROR_NOT_IMPLEMENT;

  // A[JCo𐶐
  ArchiverFactory  theArcFactory;
  Archiver  *theArc = theArcFactory.Create(GetFormatType(inSrc, NULL));
  if (NULL == theArc)
    return SPI_ERROR_MEMORY_ALLOCATION;

  // A[JCuJ
  int theRet = theArc->Open(inSrc);
  if (SPI_OK != theRet)
  {
    delete theArc;
    return SPI_ERROR_FILE_READ;
  }

  // ot@C̊i[t@C擾
  FILEINFO  theFileInfo;
  theArc->GetArcFileInfo(inLen, &theFileInfo);

  // o̓obt@mۂ
  HLOCAL  theOutBuf = LocalAlloc(LMEM_MOVEABLE, theFileInfo.mOriginalSize);
  *(HLOCAL *)ioDst = theOutBuf;
  if (NULL == theOutBuf)
  {
    delete [] theArc;
    return SPI_ERROR_MEMORY_ALLOCATION;
  }

  // o
  BYTE *theOutP = (BYTE *)LocalLock(theOutBuf);
  theArc->Extract(inLen, theOutP, theFileInfo.mOriginalSize);
  LocalUnlock(theOutBuf);

  delete theArc;

  // o͂
  /*
  if (SPI_OUTPUT_DISKFILE == theParam.Flags(FLAG_OUTPUT_TYPE))
  {
    char  theFileName[MAX_PATH];
    wsprintf(theFileName, "%s\\%s", ioDst, theFileInfo.mFileName);
    StreamWinFileFactory  theFac;
    Stream  *theOutFile = theFac.Create();
  }
  else
    */
  if (NULL != Progress)
    Progress(1, 1, inData);

  return SPI_OK;
}


// ----------------------------------------------------------------------------
//  ConfigurationDlg()
// ----------------------------------------------------------------------------

#ifdef ENABLE_CONFIGDLG
int WINAPI ConfigurationDlg(HWND inParent, int inFunc)
{
  if (0 == inFunc)
    MessageBox(inParent, gDescription, "vOC̏", MB_OK);
  else if (1 == inFunc)
  {
    DialogBox(gInst, MAKEINTRESOURCE(IDD_CONFIG), inParent, (DLGPROC)DlgProc);
    gCfg->Save(gPluginRegKey);
    ResetPlugin();
  }
  else
    return SPI_ERROR_ERROR;
  return SPI_OK;
}
#endif // ENABLE_CONFIGDLG
