// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  archiver.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "archiver.h"


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

const char *gDescription = "MGX extract plug-in ver.0.01 (C) miyax 2002.";

const char *gExtension[] = 
{
  "*.mgx",
};

const char *gFormatName[] = 
{
  "MGX archive",
};

const int gFormatTypes = sizeof(gExtension) / sizeof(gExtension[0]);


// ----------------------------------------------------------------------------
//  A[JCo
// ----------------------------------------------------------------------------

// ---
//  RXgN^EfXgN^
// ---

Archiver::Archiver(void)
{
  mArcName = NULL;
}

Archiver::~Archiver()
{
  if (NULL != mArcName)
    delete [] mArcName;
}


// ---
//  A[JCuJ
// ---

int Archiver::Open(const char *inArcName)
{
  Close();
  mArcName = new char [strlen(inArcName) + 1];
  strcpy(mArcName, inArcName);
  int theRet = Open_real();
  if (SPI_OK != theRet)
    Close();
  return theRet;
}


// ---
//  A[JCu
// ---

void Archiver::Close(void)
{
  if (NULL != mArcName)
  {
    Close_real();
    delete [] mArcName;
    mArcName = NULL;
  }
}


// ----------------------------------------------------------------------------
//  Zyx MGX A[JCo
// ----------------------------------------------------------------------------

class MGX_Archiver : public Archiver
{
public:
  MGX_Archiver(void);
  ~MGX_Archiver();

  int IsSupportedFormat(const char *inFileName, Stream *inStrm);

  DWORD GetFileCount(void);
  int GetArcFileInfo(const char *inFileName, StrCmpFunc inStrCmp, FILEINFO *outInfo);
  int GetArcFileInfo(DWORD inFileNo, FILEINFO *outInfo);
  int Extract(DWORD inFileNo, BYTE *outBuf, DWORD inBufSize);

protected:
  int Open_real(void);
  void Close_real(void);

  int ReadArcHeader(void);
  int ReadArcIndex(void);

  int ArcIndexToFILEINFO(FILEINFO *outInfo, int inFileNo);

  // A[JCuwb_
  struct ArcHeader
  {
    BYTE   mID[8];      // "SM2MPX10"
    DWORD  mFileCount;
    DWORD  mHeaderAndIndexSize;
    char   mArchiveName[12];
    DWORD  mUnknown;
  };

  // i[t@C
  struct ArcIndex
  {
    char   mFileName[12];
    DWORD  mPosition;
    DWORD  mSize;
  };

  Stream     *mArcFile;
  ArcHeader  mArcHdr;
  ArcIndex   *mArcIdx;
};


// ---
//  RXgN^EfXgN^
// ---

MGX_Archiver::MGX_Archiver(void)
{
  mArcFile = NULL;
  mArcIdx = NULL;
}

MGX_Archiver::~MGX_Archiver()
{
  Close_real();
}


// ---
//  ΉĂ`ׂ
// ---

int MGX_Archiver::IsSupportedFormat(const char *inFileName, Stream *inStrm)
{
  inStrm->Seek(0);

  // wb_`FbN
  ArcHeader  theHdr;
  inStrm->GetBytes(&theHdr, sizeof(ArcHeader));
  if (0 != memcmp(theHdr.mID, "SM2MPX10", 8) ||
      0 == theHdr.mFileCount ||
      (sizeof(ArcHeader) + theHdr.mFileCount * sizeof(ArcIndex))
        != theHdr.mHeaderAndIndexSize ||
      0x20 != theHdr.mUnknown)
    return 0;

  // ŏ̊i[t@C`FbN
  /*
  ArcIndex  theIdx;
  inStrm->GetBytes(&theIdx, sizeof(ArcIndex));
  if ((sizeof(ArcHeader) + theHdr.mFileCount * sizeof(ArcIndex) + 0x0F) & (~0x0FUL)
        != theIdx.mPosition)
    return 0;
   */

  return 1;
}


// ---
//  A[JCuۂɊJ
// ---

int MGX_Archiver::Open_real(void)
{
  StreamWinFileFactory  theFactory;
  mArcFile = theFactory.Create();

  // A[JCut@CJ
  if (0 != mArcFile->OpenIn(mArcName, 0))
    return SPI_ERROR_FILE_READ;

  // A[JCuwb_ǂݍ
  int theRet = ReadArcHeader();
  if (SPI_OK != theRet)
    return theRet;

  // i[t@Cǂݍ
  theRet = ReadArcIndex();
  if (SPI_OK != theRet)
    return theRet;

  return SPI_OK;
}


// ---
//  A[JCuwb_ǂݍ
// ---

int MGX_Archiver::ReadArcHeader(void)
{
  mArcFile->Seek(0);
  if (sizeof(ArcHeader) != mArcFile->GetBytes(&mArcHdr, sizeof(ArcHeader)))
    return SPI_ERROR_FILE_READ;
  else
    return SPI_OK;
}


// ---
//  i[t@Cǂݍ
// ---

int MGX_Archiver::ReadArcIndex(void)
{
  mArcIdx = new ArcIndex [mArcHdr.mFileCount];
  if (NULL == mArcIdx)
    return SPI_ERROR_MEMORY_ALLOCATION;

//  mArcFile->Seek(sizeof(ArcHeader));
  int  theReadSize = (int)mArcHdr.mFileCount * sizeof(ArcIndex);
  if (theReadSize != mArcFile->GetBytes(mArcIdx, theReadSize))
    return SPI_ERROR_FILE_READ;
  else
    return SPI_OK;
}


// ---
//  A[JCuۂɕ
// ---

void MGX_Archiver::Close_real(void)
{
  if (NULL != mArcFile)
  {
    delete mArcFile;
    mArcFile = NULL;
  }
  if (NULL != mArcIdx)
  {
    delete [] mArcIdx;
    mArcIdx = NULL;
  }
}


// ---
//  i[t@C̐擾
// ---

DWORD MGX_Archiver::GetFileCount(void)
{
  return mArcHdr.mFileCount;
}


// ---
//  i[t@C擾
// ---

// t@C擾
int MGX_Archiver::GetArcFileInfo(const char *inFileName, StrCmpFunc inStrCmp, FILEINFO *outInfo)
{
  DWORD  theI;
  for (theI = 0; theI < mArcHdr.mFileCount; theI++)
  {
    ArcIndexToFILEINFO(outInfo, theI);
    if (0 == inStrCmp(inFileName, outInfo->mFileName))
      return SPI_OK;
  }
  return SPI_ERROR_UNKNOWN_FORMAT;
}

// t@Cԍ擾
int MGX_Archiver::GetArcFileInfo(DWORD inFileNo, FILEINFO *outInfo)
{
  if (inFileNo < mArcHdr.mFileCount)
    return ArcIndexToFILEINFO(outInfo, inFileNo);
  else
    return SPI_ERROR_ERROR;
}


// ---
//  i[t@C` FILEINFO `ɕϊ
// ---

int MGX_Archiver::ArcIndexToFILEINFO(FILEINFO *outInfo, int inFileNo)
{
  memcpy(outInfo->mMethodName, "Zyx-MGX\0", 8);
  outInfo->mPosition       = inFileNo;
  outInfo->mCompressedSize = mArcIdx[inFileNo].mSize;
  outInfo->mOriginalSize   = mArcIdx[inFileNo].mSize;
  outInfo->mTimeStamp      = 0;
  outInfo->mPath[0]        = '\0';
  strncpy(outInfo->mFileName, mArcIdx[inFileNo].mFileName, 12);
  outInfo->mFileName[12]   = '\0';
  outInfo->mCRC            = 0;
  return SPI_OK;
}


// ---
//  i[t@C𒊏o
// ---

int MGX_Archiver::Extract(DWORD inFileNo, BYTE *outBuf, DWORD inBufSize)
{
  if (inFileNo < mArcHdr.mFileCount)
  {
    mArcFile->Seek(mArcIdx[inFileNo].mPosition);
    mArcFile->GetBytes(outBuf, inBufSize);
    return SPI_OK;
  }
  else
    return SPI_ERROR_ERROR;
}


// ----------------------------------------------------------------------------
//  tH[}bg̎ʂ𒲂ׂ
//
//  ߂lFOȏ  ΉtH[}bgiʔԍj
//          O  Ή
// ----------------------------------------------------------------------------

int GetFormatType(const char *inFileName, Stream *inStrm)
{
  Stream  *theStrm;
  if (NULL != inStrm)
    theStrm = inStrm;
  else
  {
    StreamWinFileFactory  theFac;
    theStrm = theFac.Create();
    theStrm->OpenIn(inFileName, 0);
    if (NULL == theStrm)
      delete theStrm;
  }

  int  theRet;
  ArchiverFactory  theArcFactory;
  Archiver  *theArchiver;

  for (int theI = 1; ; theI++)
  {
    theArchiver = theArcFactory.Create(theI);
    if (NULL == theArchiver)
      break;

    theRet = theArchiver->IsSupportedFormat(inFileName, theStrm);
    delete theArchiver;
    if (theRet)
    {
      theRet = theI;
      break;
    }
  }

  if (NULL == inStrm)
    delete theStrm;

  return theRet;
}


// ----------------------------------------------------------------------------
//  ArchiverFactory
// ----------------------------------------------------------------------------

Archiver *ArchiverFactory::Create(int inFormatNo)
{
  if (1 == inFormatNo)
    return new MGX_Archiver;
  else
    return NULL;
}


// ----------------------------------------------------------------------------
//  eXgR[h
// ----------------------------------------------------------------------------

#ifdef TEST_ARCHIVER_CPP

#include <stdio.h>

int main(int argc, char **argv)
{
  if (argc < 2)
  {
    puts(__FILE__ " test program");
    return 0;
  }

  int  theFormat = GetFormatType(argv[1], NULL);
  if (0 == theFormat)
  {
    puts("ΉtH[}bgł");
    return 0;
  }

  printf("tH[}bgԍF%d\n", theFormat);

  ArchiverFactory  theFac;
  Archiver  *theArc = theFac.Create(theFormat);
  if (NULL == theArc)
  {
    puts("Archiver 𐶐ł܂ł");
    return 1;
  }

  if (SPI_OK != theArc->Open(argv[1]))
  {
    puts("A[JCuI[vo܂ł");
    return 1;
  }

  FILEINFO  theFI;
  for (DWORD theI = 0; theI < theArc->GetFileCount(); theI++)
  {
    theArc->GetArcFileInfo(theI, &theFI);
    printf("t@CF%s\n"
           "ʒuF%d\n"
           "TCYF%d\n",
           theFI.mFileName, theFI.mPosition, theFI.mOriginalSize);

  }

  delete theArc;

  return 0;
}

#endif // TEST_ARCHIVER_CPP
