// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  archiver.h
// ----------------------------------------------------------------------------

#ifndef _ARCHIVER_H_
#define _ARCHIVER_H_

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "spi.h"
#include "m_stream.h"
#include "progress.h"

using namespace m_stream;


// ----------------------------------------------------------------------------
//  ^`
// ----------------------------------------------------------------------------

// r
typedef int (*StrCmpFunc)(const char *, const char *);


// ----------------------------------------------------------------------------
//  A[JCo
// ----------------------------------------------------------------------------

class Archiver
{
public:
  Archiver(void);
  virtual ~Archiver();

  virtual int IsSupportedFormat(const char *inFileName, Stream *inStrm) = 0;
  int Open(const char *inArcName);
  void Close(void);

  virtual DWORD GetFileCount(void) = 0;
  virtual int GetArcFileInfo(const char *inFileName, StrCmpFunc inStrCmp, FILEINFO *outInfo) = 0;
  virtual int GetArcFileInfo(DWORD inFileNo, FILEINFO *outInfo) = 0;
  virtual int Extract(DWORD inFileNo, BYTE *outBuf, DWORD inBufSize) = 0;


protected:
  virtual int Open_real(void) = 0;
  virtual void Close_real(void) = 0;

  char  *mArcName;
};


// ----------------------------------------------------------------------------
//  Archier ̐NX
// ----------------------------------------------------------------------------

class ArchiverFactory
{
public:
  ArchiverFactory(void) {}
  ~ArchiverFactory() {}

  Archiver *Create(int inFormatNo);
};


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

extern const char *gDescription;
extern const char *gExtension[];
extern const char *gFormatName[];
extern const int  gFormatTypes;


// ----------------------------------------------------------------------------
//  vg^Cv錾
// ----------------------------------------------------------------------------

int GetFormatType(const char *inFileName, Stream *inStrm);


#endif // _ARCHIVER_H_
