// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  cmdline.cpp  2001/12/24
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "cmdline.h"
#include <string.h>


// ----------------------------------------------------------------------------
//  QԃXCb`
// ----------------------------------------------------------------------------

class TSSwitch
{
public:
  TSSwitch(void) { mSwitch = OFF; }
  ~TSSwitch() {}

  int Switching(void) { return (mSwitch = (ON == mSwitch) ? OFF : ON); }
  int IsOn(void) { return (ON == mSwitch); }

  enum SW { OFF, ON };

private:
  SW  mSwitch;
};


// ----------------------------------------------------------------------------
//  R}hC̐؂o
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  RXgN^
// ----------------------------------------------------------------------------

CommandLine::CommandLine(const char *inCmdLine)
{
  mCmdLine = NULL;
  mParam = NULL;
  mParamCount = 0;
  if (NULL != inCmdLine)
    SetCommandLine(inCmdLine);
}


void CommandLine::SetCommandLine(const char *inCmdLine)
{
  FreeMem();
  mCmdLine = CopyStr(inCmdLine, strlen(inCmdLine));
  if (0 == Split())
    FreeMem();
}


int CommandLine::GetParamCount(void) const
{
  return mParamCount;
}


const char *CommandLine::GetParam(int inNo)
{
  if (NULL ==  mCmdLine || inNo < 0 || inNo >= mParamCount)
    return NULL;
  else
    return mParam[inNo];
}


// ----------------------------------------------------------------------------
//  qR}hC𕪊
// ----------------------------------------------------------------------------

int CommandLine::Split(void)
{
  if (NULL == mCmdLine)
    return 0;

  static const char  CHR_DQUOTE = '\"';
  static const char  CHR_SPACE  = ' ';
  static const char  CHR_BSLASH = '\\';

  char  *theTmp = CopyStr(mCmdLine, strlen(mCmdLine));
  char  *theOutP = theTmp;
  const char  *theP = mCmdLine;

  // ܂͕
  TSSwitch  theStateDQ;
  int  theParamCount = 0;
  int  thePrevC = '\0';
  while (1)
  {
    if ('\0' == *theP)  // I[
    {
      *theOutP = '\0';
      break;
    }
    else if (CHR_DQUOTE == *theP)  // _uNH[e[V
    {
      // O̕obNXbVȂA
      // _uNH[e[Vɒu
      if (CHR_BSLASH == thePrevC)
        *(theOutP - 1) = CHR_DQUOTE;
      else
        theStateDQ.Switching();
    }
    else if (CHR_SPACE == *theP && !theStateDQ.IsOn())  // _uNH[e[V̊ÕXy[X
    {
      // n߂̋؂̃Xy[X
      if ('\0' != thePrevC)
        thePrevC = *theOutP++ = '\0';
    }
    else  // ̑̕ (_uNH[e[V̒̃Xy[X܂)
    {
      if ('\0' == thePrevC)  // p[^̐擪̕
        theParamCount++;
      thePrevC = *theOutP++ = *theP;
    }
    theP++;
  }

  // e mCmdLine ɃRs[
  memcpy(mCmdLine, theTmp, strlen(mCmdLine) + 1);
  delete [] theTmp;

  // p[^ȂȂ߂
  if (0 == theParamCount)
    return 0;

  mParam = new char* [theParamCount];
  mParamCount = theParamCount;

  // ep[^̃|C^߂Ă
  theP = mCmdLine;
  for (int theI = 0; theI < theParamCount - 1; theI++)
  {
    mParam[theI] = (char *)theP;
    theP += strlen(theP);
    while ('\0' == *theP)
      theP++;
  }
  mParam[theI] = (char *)theP;  // Ō̃p[^

  return theParamCount;
}


// ----------------------------------------------------------------------------
//  CommandLine ŊmۂꂽISĂ
// ----------------------------------------------------------------------------

void CommandLine::FreeMem(void)
{
  delete [] mCmdLine; mCmdLine = NULL;
  delete [] mParam; mParam = NULL;
  mParamCount = 0;
}


char *CommandLine::CopyStr(const char *inStr, int inLen)
{
  char  *theP = new char [inLen + 1];
  memcpy(theP, inStr, inLen);
  theP[inLen] = '\0';
  return theP;
}

#ifdef TEST_CMDLINE_CPP

#include <stdio.h>

int main(int argc, char **argv)
{
  CommandLine  theCmdLine("test string   \"  \"with\" \"space      foo bar baz");

  for (int theI = 0; theI < theCmdLine.GetParamCount(); theI++)
  {
    printf("%4d: \"%s\"\n", theI, theCmdLine.GetParam(theI));
  }

  return 0;
}

#endif // TEST_CMDLINE_CPP

