// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  dropfile.cpp  2001/12/16
// ----------------------------------------------------------------------------

#include "dropfile.h"


// ----------------------------------------------------------------------------
//  vO
// ----------------------------------------------------------------------------

DroppedFiles::DroppedFiles(HDROP inDrop)
{
  mDrop = inDrop;
  if (NULL != mDrop)
    mFileCount = DragQueryFile(mDrop, 0xFFFFFFFF, NULL, 0);
  else
    mFileCount = 0;
}


DroppedFiles::~DroppedFiles()
{
  if (NULL != mDrop)
    DragFinish(mDrop);
}

unsigned int DroppedFiles::GetFileCount(void) const
{
  return mFileCount;
}


const char *DroppedFiles::GetFileName(unsigned int inNo)
{
  if (NULL != mDrop && 0 <= inNo && inNo < mFileCount)
  {
    DragQueryFile(mDrop, inNo, mBuf, MAX_PATH);
    return mBuf;
  }
  else
    return NULL;
}


