// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  edit.cpp  2001/12/15
// ----------------------------------------------------------------------------

#include "edit.h"
#include <windowsx.h>


// ----------------------------------------------------------------------------
//  萔
// ----------------------------------------------------------------------------

#define EDIT_WINDOW_STYLE_EX  WS_EX_CLIENTEDGE
#define EDIT_WINDOW_STYLE     (WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL |\
                              ES_WANTRETURN | ES_MULTILINE | \
                              ES_AUTOVSCROLL | ES_AUTOHSCROLL)


// ----------------------------------------------------------------------------
//  vO
// ----------------------------------------------------------------------------

Edit::Edit(void)
{
  mInst = NULL;
  mEdit = NULL;
}

Edit::~Edit(void)
{
  Destroy();
}

void Edit::SetInst(HINSTANCE inInst)
{
  mInst = inInst;
}

void Edit::Destroy(void)
{
  if (NULL != mEdit)
  {
    DestroyWindow(mEdit);
    DeleteObject(mFont);
    mEdit = NULL;
  }
}

#define TEXT_LIMIT  32768

int Edit::Create(HWND inParent, int inID)
{
  Destroy();

  RECT  theRect;
  GetClientRect(inParent, &theRect);

  HWND  theEdit = CreateWindowEx(EDIT_WINDOW_STYLE_EX, "EDIT", NULL, EDIT_WINDOW_STYLE,
                                 0, 0, theRect.right, theRect.bottom,
                                 inParent, (HMENU)inID, mInst, NULL);
  if (NULL == theEdit)
    return 1;

  mEdit = theEdit;
  mParent = inParent;
  mID = inID;

  LOGFONT  theLF;
  theLF.lfHeight = 20;
  theLF.lfWidth = 0;
  theLF.lfEscapement = 0;
  theLF.lfOrientation = 0;
  theLF.lfWeight = 0;
  theLF.lfItalic = FALSE;
  theLF.lfUnderline = FALSE;
  theLF.lfStrikeOut = FALSE;
  theLF.lfCharSet = SHIFTJIS_CHARSET;
  theLF.lfOutPrecision = OUT_DEFAULT_PRECIS;
  theLF.lfClipPrecision = CLIP_DEFAULT_PRECIS;
  theLF.lfQuality = DEFAULT_QUALITY;
  theLF.lfPitchAndFamily = DEFAULT_PITCH;
  strcpy(theLF.lfFaceName, "Terminal");
  mFont = CreateFontIndirect(&theLF);

  SendMessage(mEdit, WM_SETFONT, (WPARAM)mFont, FALSE);
  Edit_LimitText(mEdit, TEXT_LIMIT);

  return 0;
}

void Edit::AddText(const char *inText)
{
  int  theBegin, theTextLen = Edit_GetTextLength(mEdit);

  if (TEXT_LIMIT <= theTextLen + strlen(inText))
  {
    // NA
    int theClearedEnd = theTextLen + strlen(inText) + 1 - TEXT_LIMIT;
    Edit_SetSel(mEdit, 0, theClearedEnd);
    Edit_ReplaceSel(mEdit, "");

    theBegin = theTextLen - theClearedEnd;
  }
  else
    theBegin = theTextLen;

  Edit_SetSel(mEdit, theBegin, theBegin);
  Edit_ReplaceSel(mEdit, inText);
}

void Edit::Resize(void)
{
  RECT  theRect;
  GetClientRect(mParent, &theRect);
  MoveWindow(mEdit, theRect.left, theRect.top, theRect.right, theRect.bottom, TRUE);
}
