// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  filenamegen.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "filenamegen.h"
#include "misc.h"
#include <string.h>


// ----------------------------------------------------------------------------
//  萔
// ----------------------------------------------------------------------------

#define DEFAULT_FILENAME_FORMAT  "cb_%6n"


// ----------------------------------------------------------------------------
//  t@C
// ----------------------------------------------------------------------------

// ---
//  RXgN^
// ---

FileNameGenerator::FileNameGenerator(void)
{
  mDir[0] = mDir[MAX_PATH] = '\0';
  mExt[0] = mExt[MAX_EXTENSION] = '\0';
  mBuf[MAX_PATH] = '\0';

  mFmtParser.Parse(DEFAULT_FILENAME_FORMAT);
  mNumber = 1;
}


// ---
//  fBNgݒ肷
// ---

void FileNameGenerator::SetDirectory(const char *inDir)
{
  strncpy(mDir, inDir, MAX_PATH);
}


// ---
//  gqݒ肷
// ---

void FileNameGenerator::SetExtension(const char *inExt)
{
  strncpy(mExt, inExt, MAX_EXTENSION);
}


// ---
//  ݒ肷
// ---

void FileNameGenerator::SetFormat(const char *inFmt)
{
  if (0 != mFmtParser.Parse(inFmt))
  {
    // ^ꂽ񂪉͂łȂ炵[ȂŁA
    // Ƃ肠ĂƁ[ɃZbgĂ
    mFmtParser.Parse(DEFAULT_FILENAME_FORMAT);
  }
}


// ---
//  t@C𐶐
// ---

const char *FileNameGenerator::Generate(void)
{

  // ݎ擾
  SYSTEMTIME  theSysTime;
  GetLocalTime(&theSysTime);

  DWORD  theStartNumber = mNumber;

  char  *theP, *theEndP;
  int  theI;
  DWORD  theVal;
  TokenString  *theTknStr;
  TokenValue   *theTknVal;
  do {
    theP = mBuf;
    theEndP = mBuf + MAX_PATH;

    // ɏ]Đ
    for (theI = 0; theI < mFmtParser.GetTokenCount(); theI++)
    {
      if (Token::STRING == mFmtParser.GetToken(theI)->GetTokenType())
      {
        theTknStr = (TokenString *)mFmtParser.GetToken(theI);
        strncpy(theP, theTknStr->GetString(), theEndP - theP);
        theP += strlen(theP);
      }
      else if (Token::VALUE == mFmtParser.GetToken(theI)->GetTokenType())
      {
        theTknVal = (TokenValue *)mFmtParser.GetToken(theI);
        switch (theTknVal->GetValueType())
        {
        case TokenValue::YEAR:   theVal = theSysTime.wYear;   break;
        case TokenValue::MONTH:  theVal = theSysTime.wMonth;  break;
        case TokenValue::DAY:    theVal = theSysTime.wDay;    break;
        case TokenValue::HOUR:   theVal = theSysTime.wHour;   break;
        case TokenValue::MINUTE: theVal = theSysTime.wMinute; break;
        case TokenValue::SECOND: theVal = theSysTime.wSecond; break;
        case TokenValue::NUMBER: theVal = mNumber++;          break;
        }
        theP += ToString(theP,
                         (theTknVal->GetWidth() > (theEndP - theP))
                         ? (theEndP - theP) : theTknVal->GetWidth(),
                         theVal);
      }
    }

    // t@C̃`FbNp ".*" t
    strncpy(theP, ".*", theEndP - theP);

    // t@C݂ĂĂAAԂȂꍇ͍ĐȂ
  } while (mNumber != theStartNumber && IsExistFile(mBuf));

  // gqt
  strncpy(theP, mExt, theEndP - theP);

  return mBuf;
}


// ----------------------------------------------------------------------------
//  eXgR[h
// ----------------------------------------------------------------------------

#ifdef TEST_FILENAMEGEN_CPP

#include <stdio.h>

void SetupGenerator(FileNameGenerator *ioGen)
{
  ioGen->SetDirectory("");
  ioGen->SetExtension(".test");
  ioGen->SetFormat("clip_%2y.%2m.%2d_%2H-%2M-%2S_No.%6n");
}

int main(void)
{
  FileNameGenerator  theGeneratorA, theGeneratorB;
  SetupGenerator(&theGeneratorA);
  SetupGenerator(&theGeneratorB);

  FILE  *theFP;
  const char  *theNameA, *theNameB;
  for (int theI = 0; theI < 5; theI++)
  {
    theNameA = theGeneratorA.Generate();
    theFP = fopen(theNameA, "wb");
    if (NULL != theFP)
      fclose(theFP);

    theNameB = theGeneratorB.Generate();
    theFP = fopen(theNameB, "wb");
    if (NULL != theFP)
      fclose(theFP);

    printf("A: %s\nB: %s\n", theNameA, theNameB);
  }

  return 0;
}

#endif
