// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  filenamegen.h
// ----------------------------------------------------------------------------

#ifndef _FILENAMEGEN_H_
#define _FILENAMEGEN_H_

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "fmtparser.h"
#include <windows.h>


// ----------------------------------------------------------------------------
//  t@C
// ----------------------------------------------------------------------------

class FileNameGenerator
{
public:
  FileNameGenerator(void);
  ~FileNameGenerator() {}

  void SetDirectory(const char *inDir);
  void SetExtension(const char *inExt);
  void SetFormat(const char *inFmt);

  const char *Generate(void);

private:
  enum { MAX_EXTENSION = 32 };

  char  mDir[MAX_PATH + 1];
  char  mExt[MAX_EXTENSION + 1];
  char  mBuf[MAX_PATH + 1];

  FormatParser  mFmtParser;
  DWORD  mNumber;
};


#endif // _FILENAMEGEN_H_
